/*
 * Decompiled with CFR 0.152.
 */
package cis.common.digsig.signer.service;

import cis.common.digsig.DigitalSigningFactory;
import cis.common.digsig.certificate.AbstractKeyStoreManager;
import cis.common.digsig.certificate.KeyStoreContainerType;
import cis.common.digsig.signer.service.KeyStoreConfiguration;
import cis.common.digsig.support.Base64Utils;
import cis.common.digsig.support.CertificationChainDetails;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.PrivateKey;
import java.security.cert.CertPath;
import java.security.cert.Certificate;
import java.security.cert.CertificateEncodingException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.text.DateFormat;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.Assert;

@Service
public class CertificateService {
    private final KeyStoreConfiguration configuration;
    private static final String X509_CERTIFICATE_TYPE = "X.509";
    private static final String CERTIFICATION_CHAIN_ENCODING = "PkiPath";
    private static Locale MK_LOCALE = new Locale("mk");

    @Autowired
    public CertificateService(KeyStoreConfiguration configuration) {
        this.configuration = configuration;
    }

    public CertificationChainDetails loadCertificate() {
        try {
            AbstractKeyStoreManager am = DigitalSigningFactory.newKeyStoreLoader((KeyStoreContainerType)this.configuration.getKeyStoreContainerType(), (String)this.configuration.getKeystoreLocation(), (String)this.configuration.getKeyStorePasscode(), (String)this.configuration.getKeyStoreAlias());
            am.loadKeyStore();
            Assert.notNull((Object)am.getPrivateKeyAndCertChain(), (String)"The certificate should not be null");
            PrivateKey privateKey = am.getPrivateKeyAndCertChain().mPrivateKey;
            if (privateKey == null) {
                throw new RuntimeException("the private key is missing");
            }
            Certificate[] certChain = am.getPrivateKeyAndCertChain().mCertificationChain;
            if (certChain == null) {
                throw new RuntimeException("the crtificate chain is missing");
            }
            CertificationChainDetails certificateDetails = new CertificationChainDetails();
            DateFormat dateFormatter = DateFormat.getDateInstance(2, MK_LOCALE);
            X509Certificate clientCert = (X509Certificate)certChain[0];
            certificateDetails.setSerialNumber(clientCert.getSerialNumber().toString());
            certificateDetails.setPublisher(clientCert.getIssuerX500Principal().getName());
            certificateDetails.setValidFrom(dateFormatter.format(clientCert.getNotBefore()));
            certificateDetails.setValidTo(dateFormatter.format(clientCert.getNotAfter()));
            certificateDetails.setSubject(clientCert.getSubjectDN().getName());
            try {
                certificateDetails.setEncodedCertificate(clientCert.getEncoded());
            }
            catch (CertificateEncodingException e) {
                throw new RuntimeException(e);
            }
            try {
                certificateDetails.setCertificationChain(this.encodeX509CertChainToBase64(certChain));
            }
            catch (CertificateException cee) {
                throw new RuntimeException(cee);
            }
            return certificateDetails;
        }
        catch (IOException | GeneralSecurityException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected String encodeX509CertChainToBase64(Certificate[] aCertificationChain) throws CertificateException {
        List<Certificate> certList = Arrays.asList(aCertificationChain);
        CertificateFactory certFactory = CertificateFactory.getInstance(X509_CERTIFICATE_TYPE);
        CertPath certPath = certFactory.generateCertPath(certList);
        byte[] certPathEncoded = certPath.getEncoded(CERTIFICATION_CHAIN_ENCODING);
        String base64encodedCertChain = Base64Utils.base64Encode((byte[])certPathEncoded);
        return base64encodedCertChain;
    }
}

